<?php
/**
 * Database connection handler
 */
function get_db_connection() {
    static $conn;
    if ($conn === null) {
        mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
        try {
            $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
            $conn->set_charset("utf8mb4");
        } catch (Exception $e) {
            if(APP_DEBUG){
                 die("Database Connection Error: " . $e->getMessage());
            }
            die("Database Connection Error.");
        }
    }
    return $conn;
}
